//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsubscription

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BillingAccountClient contains the methods for the BillingAccount group.
// Don't use this type directly, use NewBillingAccountClient() instead.
type BillingAccountClient struct {
	internal *arm.Client
}

// NewBillingAccountClient creates a new instance of BillingAccountClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBillingAccountClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*BillingAccountClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BillingAccountClient{
		internal: cl,
	}
	return client, nil
}

// GetPolicy - Get Billing Account Policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - billingAccountID - Billing Account Id.
//   - options - BillingAccountClientGetPolicyOptions contains the optional parameters for the BillingAccountClient.GetPolicy
//     method.
func (client *BillingAccountClient) GetPolicy(ctx context.Context, billingAccountID string, options *BillingAccountClientGetPolicyOptions) (BillingAccountClientGetPolicyResponse, error) {
	var err error
	const operationName = "BillingAccountClient.GetPolicy"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPolicyCreateRequest(ctx, billingAccountID, options)
	if err != nil {
		return BillingAccountClientGetPolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BillingAccountClientGetPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BillingAccountClientGetPolicyResponse{}, err
	}
	resp, err := client.getPolicyHandleResponse(httpResp)
	return resp, err
}

// getPolicyCreateRequest creates the GetPolicy request.
func (client *BillingAccountClient) getPolicyCreateRequest(ctx context.Context, billingAccountID string, options *BillingAccountClientGetPolicyOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Subscription/policies/default"
	if billingAccountID == "" {
		return nil, errors.New("parameter billingAccountID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountId}", url.PathEscape(billingAccountID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPolicyHandleResponse handles the GetPolicy response.
func (client *BillingAccountClient) getPolicyHandleResponse(resp *http.Response) (BillingAccountClientGetPolicyResponse, error) {
	result := BillingAccountClientGetPolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BillingAccountPoliciesResponse); err != nil {
		return BillingAccountClientGetPolicyResponse{}, err
	}
	return result, nil
}
