//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoep_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/oep/armoep"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_ListByResourceGroup.json
func ExampleEnergyServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnergyServicesClient().NewListByResourceGroupPager("DummyResourceGroupName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EnergyServiceList = armoep.EnergyServiceList{
		// 	Value: []*armoep.EnergyService{
		// 		{
		// 			Name: to.Ptr("DummyResourceName"),
		// 			Type: to.Ptr("Microsoft.OEP/oepResource"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/DummyResourceGroupName/providers/Microsoft.OEP/oepResource/DummyResourceName"),
		// 			Location: to.Ptr("WestUS"),
		// 			Properties: &armoep.EnergyServiceProperties{
		// 				AuthAppID: to.Ptr("sample-id"),
		// 				DataPartitionNames: []*armoep.DataPartitionNames{
		// 					{
		// 						Name: to.Ptr("dataPartition1"),
		// 					},
		// 					{
		// 						Name: to.Ptr("dataPartition2"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armoep.ProvisioningStateSucceeded),
		// 			},
		// 			Tags: map[string]*string{
		// 				"additionalProps1": to.Ptr("additional properties"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_ListBySubscriptionId.json
func ExampleEnergyServicesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnergyServicesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EnergyServiceList = armoep.EnergyServiceList{
		// 	Value: []*armoep.EnergyService{
		// 		{
		// 			Name: to.Ptr("DummyResourceName"),
		// 			Type: to.Ptr("Microsoft.OEP/oepResource"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/DummyResourceGroupName/providers/Microsoft.OEP/oepResource/DummyResourceName"),
		// 			Location: to.Ptr("WestUS"),
		// 			Properties: &armoep.EnergyServiceProperties{
		// 				AuthAppID: to.Ptr("sample-id"),
		// 				DataPartitionNames: []*armoep.DataPartitionNames{
		// 					{
		// 						Name: to.Ptr("dataPartition1"),
		// 					},
		// 					{
		// 						Name: to.Ptr("dataPartition2"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armoep.ProvisioningStateSucceeded),
		// 			},
		// 			Tags: map[string]*string{
		// 				"additionalProps1": to.Ptr("additional properties"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_Get.json
func ExampleEnergyServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnergyServicesClient().Get(ctx, "DummyResourceGroupName", "DummyResourceName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnergyService = armoep.EnergyService{
	// 	Name: to.Ptr("DummyResourceName"),
	// 	Type: to.Ptr("Microsoft.OEP/oepResource"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/DummyResourceGroupName/providers/Microsoft.OEP/oepResource/DummyResourceName"),
	// 	Location: to.Ptr("WestUS"),
	// 	Properties: &armoep.EnergyServiceProperties{
	// 		AuthAppID: to.Ptr("sample-id"),
	// 		DataPartitionNames: []*armoep.DataPartitionNames{
	// 			{
	// 				Name: to.Ptr("dataPartition1"),
	// 			},
	// 			{
	// 				Name: to.Ptr("dataPartition2"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armoep.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"additionalProps1": to.Ptr("additional properties"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_Create.json
func ExampleEnergyServicesClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnergyServicesClient().BeginCreate(ctx, "DummyResourceGroupName", "DummyResourceName", &armoep.EnergyServicesClientBeginCreateOptions{Body: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnergyService = armoep.EnergyService{
	// 	Name: to.Ptr("DummyResourceName"),
	// 	Type: to.Ptr("Microsoft.OEP/oepResource"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/DummyResourceGroupName/providers/Microsoft.OEP/oepResource/DummyResourceName"),
	// 	Location: to.Ptr("WestUS"),
	// 	Properties: &armoep.EnergyServiceProperties{
	// 		AuthAppID: to.Ptr("sample-id"),
	// 		DataPartitionNames: []*armoep.DataPartitionNames{
	// 			{
	// 				Name: to.Ptr("dataPartition1"),
	// 			},
	// 			{
	// 				Name: to.Ptr("dataPartition2"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armoep.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"additionalProps1": to.Ptr("additional properties"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_Update.json
func ExampleEnergyServicesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnergyServicesClient().Update(ctx, "DummyResourceGroupName", "DummyResourceName", &armoep.EnergyServicesClientUpdateOptions{Body: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnergyService = armoep.EnergyService{
	// 	Name: to.Ptr("DummyResourceName"),
	// 	Type: to.Ptr("Microsoft.OEP/oepResource"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/DummyResourceGroupName/providers/Microsoft.OEP/oepResource/DummyResourceName"),
	// 	Location: to.Ptr("WestUS"),
	// 	Properties: &armoep.EnergyServiceProperties{
	// 		AuthAppID: to.Ptr("sample-id"),
	// 		DataPartitionNames: []*armoep.DataPartitionNames{
	// 			{
	// 				Name: to.Ptr("dataPartition1"),
	// 			},
	// 			{
	// 				Name: to.Ptr("dataPartition2"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armoep.ProvisioningStateSucceeded),
	// 	},
	// 	Tags: map[string]*string{
	// 		"additionalProps1": to.Ptr("additional properties"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/OepResource_Delete.json
func ExampleEnergyServicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnergyServicesClient().BeginDelete(ctx, "DummyResourceGroupName", "DummyResourceName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/EnergyServices_AddPartition_MaximumSet_Gen.json
func ExampleEnergyServicesClient_BeginAddPartition() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnergyServicesClient().BeginAddPartition(ctx, "rgoep", "a", &armoep.EnergyServicesClientBeginAddPartitionOptions{Body: &armoep.DataPartitionAddOrRemoveRequest{
		Name: to.Ptr("aaaaaaaaaaaaaaaaaa"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/EnergyServices_RemovePartition_MaximumSet_Gen.json
func ExampleEnergyServicesClient_BeginRemovePartition() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnergyServicesClient().BeginRemovePartition(ctx, "rgoep", "aaaaaaa", &armoep.EnergyServicesClientBeginRemovePartitionOptions{Body: &armoep.DataPartitionAddOrRemoveRequest{
		Name: to.Ptr("aaaaaaaaaaaaaaaaaa"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/oep/resource-manager/Microsoft.OpenEnergyPlatform/preview/2022-04-04-preview/examples/EnergyServices_ListPartitions_MaximumSet_Gen.json
func ExampleEnergyServicesClient_ListPartitions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoep.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnergyServicesClient().ListPartitions(ctx, "rgoep", "aaaaaaaaaaaaaaaaaaa", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataPartitionsListResult = armoep.DataPartitionsListResult{
	// 	Value: []*armoep.DataPartitionProperties{
	// 		{
	// 			Name: to.Ptr("aaaaaaaaaaa"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 	}},
	// }
}
