//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayGet.json
func ExampleVPNGatewaysClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVPNGatewaysClient().Get(ctx, "rg1", "gateway1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNGateway = armnetwork.VPNGateway{
	// 	Name: to.Ptr("gateway1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1"),
	// 	Location: to.Ptr("West US"),
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNGatewayProperties{
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65514),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.5")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.30.0.4")},
	// 							IPConfigurationID: to.Ptr("Instance0"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("104.208.48.178")},
	// 							},
	// 							{
	// 								CustomBgpIPAddresses: []*string{
	// 									to.Ptr("169.254.21.10")},
	// 									DefaultBgpIPAddresses: []*string{
	// 										to.Ptr("10.30.0.5")},
	// 										IPConfigurationID: to.Ptr("Instance1"),
	// 										TunnelIPAddresses: []*string{
	// 											to.Ptr("104.208.48.179")},
	// 									}},
	// 									PeerWeight: to.Ptr[int32](0),
	// 								},
	// 								Connections: []*armnetwork.VPNConnection{
	// 									{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1"),
	// 										Name: to.Ptr("vpnConnection1"),
	// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 										Properties: &armnetwork.VPNConnectionProperties{
	// 											EgressBytesTransferred: to.Ptr[int64](0),
	// 											EnableInternetSecurity: to.Ptr(false),
	// 											IngressBytesTransferred: to.Ptr[int64](0),
	// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 											RemoteVPNSite: &armnetwork.SubResource{
	// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
	// 											},
	// 											RoutingConfiguration: &armnetwork.RoutingConfiguration{
	// 												AssociatedRouteTable: &armnetwork.SubResource{
	// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 												},
	// 												PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
	// 													IDs: []*armnetwork.SubResource{
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
	// 													}},
	// 													Labels: []*string{
	// 														to.Ptr("label1"),
	// 														to.Ptr("label2")},
	// 													},
	// 													VnetRoutes: &armnetwork.VnetRoute{
	// 														StaticRoutes: []*armnetwork.StaticRoute{
	// 														},
	// 													},
	// 												},
	// 												VPNLinkConnections: []*armnetwork.VPNSiteLinkConnection{
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link1"),
	// 														Name: to.Ptr("Connection-Link1"),
	// 														Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
	// 														Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 														Properties: &armnetwork.VPNSiteLinkConnectionProperties{
	// 															ConnectionBandwidth: to.Ptr[int32](200),
	// 															EgressBytesTransferred: to.Ptr[int64](0),
	// 															EnableBgp: to.Ptr(false),
	// 															EnableRateLimiting: to.Ptr(false),
	// 															IngressBytesTransferred: to.Ptr[int64](0),
	// 															IngressNatRules: []*armnetwork.SubResource{
	// 																{
	// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
	// 															}},
	// 															IPSecPolicies: []*armnetwork.IPSecPolicy{
	// 															},
	// 															ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 															RoutingWeight: to.Ptr[int32](0),
	// 															SharedKey: to.Ptr("key"),
	// 															UseLocalAzureIPAddress: to.Ptr(false),
	// 															UsePolicyBasedTrafficSelectors: to.Ptr(false),
	// 															VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
	// 															VPNSiteLink: &armnetwork.SubResource{
	// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
	// 															},
	// 														},
	// 													},
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link2"),
	// 														Name: to.Ptr("Connection-Link2"),
	// 														Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
	// 														Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 														Properties: &armnetwork.VPNSiteLinkConnectionProperties{
	// 															ConnectionBandwidth: to.Ptr[int32](200),
	// 															EgressBytesTransferred: to.Ptr[int64](0),
	// 															EgressNatRules: []*armnetwork.SubResource{
	// 																{
	// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat04"),
	// 															}},
	// 															EnableBgp: to.Ptr(false),
	// 															EnableRateLimiting: to.Ptr(false),
	// 															IngressBytesTransferred: to.Ptr[int64](0),
	// 															IPSecPolicies: []*armnetwork.IPSecPolicy{
	// 															},
	// 															ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 															RoutingWeight: to.Ptr[int32](0),
	// 															SharedKey: to.Ptr("key"),
	// 															UseLocalAzureIPAddress: to.Ptr(false),
	// 															UsePolicyBasedTrafficSelectors: to.Ptr(false),
	// 															VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
	// 															VPNSiteLink: &armnetwork.SubResource{
	// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink2"),
	// 															},
	// 														},
	// 												}},
	// 											},
	// 									}},
	// 									EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 									IsRoutingPreferenceInternet: to.Ptr(false),
	// 									NatRules: []*armnetwork.VPNGatewayNatRule{
	// 										{
	// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
	// 											Name: to.Ptr("nat03"),
	// 											Type: to.Ptr("Microsoft.Network/vpnGateways/natRules"),
	// 											Properties: &armnetwork.VPNGatewayNatRuleProperties{
	// 												Type: to.Ptr(armnetwork.VPNNatRuleTypeDynamic),
	// 												ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("192.168.0.0/26"),
	// 												}},
	// 												IngressVPNSiteLinkConnections: []*armnetwork.SubResource{
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link1"),
	// 												}},
	// 												InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("0.0.0.0/26"),
	// 												}},
	// 												Mode: to.Ptr(armnetwork.VPNNatRuleMode("IgressSnat")),
	// 											},
	// 										},
	// 										{
	// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat04"),
	// 											Name: to.Ptr("nat04"),
	// 											Type: to.Ptr("Microsoft.Network/vpnGateways/natRules"),
	// 											Properties: &armnetwork.VPNGatewayNatRuleProperties{
	// 												Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 												EgressVPNSiteLinkConnections: []*armnetwork.SubResource{
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link2"),
	// 												}},
	// 												ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("192.168.0.0/26"),
	// 												}},
	// 												InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("0.0.0.0/26"),
	// 												}},
	// 												Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 											},
	// 									}},
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									VirtualHub: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
	// 									},
	// 								},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayPut.json
func ExampleVPNGatewaysClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginCreateOrUpdate(ctx, "rg1", "gateway1", armnetwork.VPNGateway{
		Location: to.Ptr("westcentralus"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.VPNGatewayProperties{
			BgpSettings: &armnetwork.BgpSettings{
				Asn: to.Ptr[int64](65515),
				BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
					{
						CustomBgpIPAddresses: []*string{
							to.Ptr("169.254.21.5")},
						IPConfigurationID: to.Ptr("Instance0"),
					},
					{
						CustomBgpIPAddresses: []*string{
							to.Ptr("169.254.21.10")},
						IPConfigurationID: to.Ptr("Instance1"),
					}},
				PeerWeight: to.Ptr[int32](0),
			},
			Connections: []*armnetwork.VPNConnection{
				{
					Name: to.Ptr("vpnConnection1"),
					Properties: &armnetwork.VPNConnectionProperties{
						RemoteVPNSite: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
						},
						VPNLinkConnections: []*armnetwork.VPNSiteLinkConnection{
							{
								Name: to.Ptr("Connection-Link1"),
								Properties: &armnetwork.VPNSiteLinkConnectionProperties{
									ConnectionBandwidth: to.Ptr[int32](200),
									EgressNatRules: []*armnetwork.SubResource{
										{
											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
										}},
									SharedKey:                 to.Ptr("key"),
									VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
									VPNSiteLink: &armnetwork.SubResource{
										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
									},
								},
							}},
					},
				}},
			EnableBgpRouteTranslationForNat: to.Ptr(false),
			IsRoutingPreferenceInternet:     to.Ptr(false),
			NatRules: []*armnetwork.VPNGatewayNatRule{
				{
					Name: to.Ptr("nat03"),
					Properties: &armnetwork.VPNGatewayNatRuleProperties{
						Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
						ExternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("192.168.0.0/26"),
							}},
						InternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("0.0.0.0/26"),
							}},
						IPConfigurationID: to.Ptr(""),
						Mode:              to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
					},
				}},
			VirtualHub: &armnetwork.SubResource{
				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNGateway = armnetwork.VPNGateway{
	// 	Name: to.Ptr("gateway1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1"),
	// 	Location: to.Ptr("West US"),
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNGatewayProperties{
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65514),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.5")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.30.0.4")},
	// 							IPConfigurationID: to.Ptr("Instance0"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("104.208.48.178")},
	// 							},
	// 							{
	// 								CustomBgpIPAddresses: []*string{
	// 									to.Ptr("169.254.21.10")},
	// 									DefaultBgpIPAddresses: []*string{
	// 										to.Ptr("10.30.0.5")},
	// 										IPConfigurationID: to.Ptr("Instance1"),
	// 										TunnelIPAddresses: []*string{
	// 											to.Ptr("104.208.48.179")},
	// 									}},
	// 									PeerWeight: to.Ptr[int32](0),
	// 								},
	// 								Connections: []*armnetwork.VPNConnection{
	// 									{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1"),
	// 										Name: to.Ptr("vpnConnection1"),
	// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 										Properties: &armnetwork.VPNConnectionProperties{
	// 											EgressBytesTransferred: to.Ptr[int64](0),
	// 											EnableInternetSecurity: to.Ptr(false),
	// 											IngressBytesTransferred: to.Ptr[int64](0),
	// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 											RemoteVPNSite: &armnetwork.SubResource{
	// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
	// 											},
	// 											RoutingConfiguration: &armnetwork.RoutingConfiguration{
	// 												AssociatedRouteTable: &armnetwork.SubResource{
	// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 												},
	// 												PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
	// 													IDs: []*armnetwork.SubResource{
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
	// 													}},
	// 													Labels: []*string{
	// 														to.Ptr("label1"),
	// 														to.Ptr("label2")},
	// 													},
	// 													VnetRoutes: &armnetwork.VnetRoute{
	// 														StaticRoutes: []*armnetwork.StaticRoute{
	// 														},
	// 													},
	// 												},
	// 												VPNLinkConnections: []*armnetwork.VPNSiteLinkConnection{
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link1"),
	// 														Name: to.Ptr("Connection-Link1"),
	// 														Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
	// 														Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 														Properties: &armnetwork.VPNSiteLinkConnectionProperties{
	// 															ConnectionBandwidth: to.Ptr[int32](200),
	// 															EgressBytesTransferred: to.Ptr[int64](0),
	// 															EgressNatRules: []*armnetwork.SubResource{
	// 																{
	// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
	// 															}},
	// 															EnableBgp: to.Ptr(false),
	// 															EnableRateLimiting: to.Ptr(false),
	// 															IngressBytesTransferred: to.Ptr[int64](0),
	// 															IPSecPolicies: []*armnetwork.IPSecPolicy{
	// 															},
	// 															ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 															RoutingWeight: to.Ptr[int32](0),
	// 															SharedKey: to.Ptr("key"),
	// 															UseLocalAzureIPAddress: to.Ptr(false),
	// 															UsePolicyBasedTrafficSelectors: to.Ptr(false),
	// 															VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
	// 															VPNSiteLink: &armnetwork.SubResource{
	// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
	// 															},
	// 														},
	// 												}},
	// 											},
	// 									}},
	// 									IsRoutingPreferenceInternet: to.Ptr(false),
	// 									NatRules: []*armnetwork.VPNGatewayNatRule{
	// 										{
	// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
	// 											Name: to.Ptr("nat03"),
	// 											Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 											Properties: &armnetwork.VPNGatewayNatRuleProperties{
	// 												Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 												EgressVPNSiteLinkConnections: []*armnetwork.SubResource{
	// 													{
	// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link1"),
	// 												}},
	// 												ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("192.168.0.0/26"),
	// 												}},
	// 												InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 													{
	// 														AddressSpace: to.Ptr("0.0.0.0/26"),
	// 												}},
	// 												Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 											},
	// 									}},
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									VirtualHub: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
	// 									},
	// 								},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayUpdateTags.json
func ExampleVPNGatewaysClient_BeginUpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginUpdateTags(ctx, "rg1", "gateway1", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNGateway = armnetwork.VPNGateway{
	// 	Name: to.Ptr("gateway1"),
	// 	Type: to.Ptr("Microsoft.Network/vpnGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNGatewayProperties{
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65515),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.5")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.30.0.4")},
	// 							IPConfigurationID: to.Ptr("Instance0"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("104.208.48.178")},
	// 							},
	// 							{
	// 								CustomBgpIPAddresses: []*string{
	// 									to.Ptr("169.254.21.10")},
	// 									DefaultBgpIPAddresses: []*string{
	// 										to.Ptr("10.30.0.5")},
	// 										IPConfigurationID: to.Ptr("Instance1"),
	// 										TunnelIPAddresses: []*string{
	// 											to.Ptr("104.208.48.179")},
	// 									}},
	// 									PeerWeight: to.Ptr[int32](0),
	// 								},
	// 								Connections: []*armnetwork.VPNConnection{
	// 									{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1"),
	// 										Name: to.Ptr("vpnConnection1"),
	// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 										Properties: &armnetwork.VPNConnectionProperties{
	// 											ConnectionStatus: to.Ptr(armnetwork.VPNConnectionStatusConnected),
	// 											EgressBytesTransferred: to.Ptr[int64](0),
	// 											EnableBgp: to.Ptr(false),
	// 											IngressBytesTransferred: to.Ptr[int64](0),
	// 											IPSecPolicies: []*armnetwork.IPSecPolicy{
	// 											},
	// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 											RemoteVPNSite: &armnetwork.SubResource{
	// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
	// 											},
	// 											RoutingConfiguration: &armnetwork.RoutingConfiguration{
	// 												AssociatedRouteTable: &armnetwork.SubResource{
	// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 												},
	// 												PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
	// 													IDs: []*armnetwork.SubResource{
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
	// 													}},
	// 													Labels: []*string{
	// 														to.Ptr("label1"),
	// 														to.Ptr("label2")},
	// 													},
	// 													VnetRoutes: &armnetwork.VnetRoute{
	// 														StaticRoutes: []*armnetwork.StaticRoute{
	// 														},
	// 													},
	// 												},
	// 												RoutingWeight: to.Ptr[int32](0),
	// 												SharedKey: to.Ptr("key"),
	// 											},
	// 									}},
	// 									EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 									IsRoutingPreferenceInternet: to.Ptr(false),
	// 									NatRules: []*armnetwork.VPNGatewayNatRule{
	// 									},
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									VirtualHub: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
	// 									},
	// 								},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayDelete.json
func ExampleVPNGatewaysClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginDelete(ctx, "rg1", "gateway1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayReset.json
func ExampleVPNGatewaysClient_BeginReset() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginReset(ctx, "rg1", "vpngw", &armnetwork.VPNGatewaysClientBeginResetOptions{IPConfigurationID: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNGateway = armnetwork.VPNGateway{
	// 	Name: to.Ptr("vpngw"),
	// 	Type: to.Ptr("Microsoft.Network/vpnGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/vpngw"),
	// 	Location: to.Ptr("West US"),
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.VPNGatewayProperties{
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65514),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.5")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.30.0.4")},
	// 							IPConfigurationID: to.Ptr("Instance0"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("104.208.48.178")},
	// 							},
	// 							{
	// 								CustomBgpIPAddresses: []*string{
	// 									to.Ptr("169.254.21.10")},
	// 									DefaultBgpIPAddresses: []*string{
	// 										to.Ptr("10.30.0.5")},
	// 										IPConfigurationID: to.Ptr("Instance1"),
	// 										TunnelIPAddresses: []*string{
	// 											to.Ptr("104.208.48.179")},
	// 									}},
	// 									PeerWeight: to.Ptr[int32](0),
	// 								},
	// 								Connections: []*armnetwork.VPNConnection{
	// 									{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/vpngw/vpnConnections/vpnConnection1"),
	// 										Name: to.Ptr("vpnConnection1"),
	// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 										Properties: &armnetwork.VPNConnectionProperties{
	// 											ConnectionBandwidth: to.Ptr[int32](100),
	// 											ConnectionStatus: to.Ptr(armnetwork.VPNConnectionStatusConnected),
	// 											EgressBytesTransferred: to.Ptr[int64](0),
	// 											EnableBgp: to.Ptr(false),
	// 											IngressBytesTransferred: to.Ptr[int64](0),
	// 											IPSecPolicies: []*armnetwork.IPSecPolicy{
	// 											},
	// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 											RemoteVPNSite: &armnetwork.SubResource{
	// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
	// 											},
	// 											RoutingConfiguration: &armnetwork.RoutingConfiguration{
	// 												AssociatedRouteTable: &armnetwork.SubResource{
	// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 												},
	// 												PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
	// 													IDs: []*armnetwork.SubResource{
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
	// 														},
	// 														{
	// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
	// 													}},
	// 													Labels: []*string{
	// 														to.Ptr("label1"),
	// 														to.Ptr("label2")},
	// 													},
	// 													VnetRoutes: &armnetwork.VnetRoute{
	// 														StaticRoutes: []*armnetwork.StaticRoute{
	// 														},
	// 													},
	// 												},
	// 												RoutingWeight: to.Ptr[int32](0),
	// 												SharedKey: to.Ptr("key"),
	// 												UseLocalAzureIPAddress: to.Ptr(false),
	// 											},
	// 									}},
	// 									EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 									IsRoutingPreferenceInternet: to.Ptr(false),
	// 									NatRules: []*armnetwork.VPNGatewayNatRule{
	// 									},
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									VirtualHub: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
	// 									},
	// 								},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayStartPacketCaptureFilterData.json
func ExampleVPNGatewaysClient_BeginStartPacketCapture_startPacketCaptureOnVpnGatewayWithFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginStartPacketCapture(ctx, "rg1", "vpngw", &armnetwork.VPNGatewaysClientBeginStartPacketCaptureOptions{Parameters: &armnetwork.VPNGatewayPacketCaptureStartParameters{
		FilterData: to.Ptr("{'TracingFlags': 11,'MaxPacketBufferSize': 120,'MaxFileSize': 200,'Filters': [{'SourceSubnets': ['20.1.1.0/24'],'DestinationSubnets': ['10.1.1.0/24'],'SourcePort': [500],'DestinationPort': [4500],'Protocol': 6,'TcpFlags': 16,'CaptureSingleDirectionTrafficOnly': true}]}"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayStartPacketCapture.json
func ExampleVPNGatewaysClient_BeginStartPacketCapture_startPacketCaptureOnVpnGatewayWithoutFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginStartPacketCapture(ctx, "rg1", "vpngw", &armnetwork.VPNGatewaysClientBeginStartPacketCaptureOptions{Parameters: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayStopPacketCapture.json
func ExampleVPNGatewaysClient_BeginStopPacketCapture() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVPNGatewaysClient().BeginStopPacketCapture(ctx, "rg1", "vpngw", &armnetwork.VPNGatewaysClientBeginStopPacketCaptureOptions{Parameters: &armnetwork.VPNGatewayPacketCaptureStopParameters{
		SasURL: to.Ptr("https://teststorage.blob.core.windows.net/?sv=2018-03-28&ss=bfqt&srt=sco&sp=rwdlacup&se=2019-09-13T07:44:05Z&st=2019-09-06T23:44:05Z&spr=https&sig=V1h9D1riltvZMI69d6ihENnFo%2FrCvTqGgjO2lf%2FVBhE%3D"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayListByResourceGroup.json
func ExampleVPNGatewaysClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVPNGatewaysClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListVPNGatewaysResult = armnetwork.ListVPNGatewaysResult{
		// 	Value: []*armnetwork.VPNGateway{
		// 		{
		// 			Name: to.Ptr("gateway1"),
		// 			Type: to.Ptr("Microsoft.Network/vpnGateways"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1"),
		// 			Location: to.Ptr("West US"),
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.VPNGatewayProperties{
		// 				BgpSettings: &armnetwork.BgpSettings{
		// 					Asn: to.Ptr[int64](65514),
		// 					BgpPeeringAddress: to.Ptr("10.0.1.30"),
		// 					BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
		// 						{
		// 							CustomBgpIPAddresses: []*string{
		// 								to.Ptr("169.254.21.5")},
		// 								DefaultBgpIPAddresses: []*string{
		// 									to.Ptr("10.30.0.4")},
		// 									IPConfigurationID: to.Ptr("Instance0"),
		// 									TunnelIPAddresses: []*string{
		// 										to.Ptr("104.208.48.178")},
		// 									},
		// 									{
		// 										CustomBgpIPAddresses: []*string{
		// 											to.Ptr("169.254.21.10")},
		// 											DefaultBgpIPAddresses: []*string{
		// 												to.Ptr("10.30.0.5")},
		// 												IPConfigurationID: to.Ptr("Instance1"),
		// 												TunnelIPAddresses: []*string{
		// 													to.Ptr("104.208.48.179")},
		// 											}},
		// 											PeerWeight: to.Ptr[int32](0),
		// 										},
		// 										Connections: []*armnetwork.VPNConnection{
		// 											{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1"),
		// 												Name: to.Ptr("vpnConnection1"),
		// 												Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 												Properties: &armnetwork.VPNConnectionProperties{
		// 													EgressBytesTransferred: to.Ptr[int64](0),
		// 													EnableInternetSecurity: to.Ptr(false),
		// 													IngressBytesTransferred: to.Ptr[int64](0),
		// 													ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 													RemoteVPNSite: &armnetwork.SubResource{
		// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
		// 													},
		// 													RoutingConfiguration: &armnetwork.RoutingConfiguration{
		// 														AssociatedRouteTable: &armnetwork.SubResource{
		// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
		// 														},
		// 														PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
		// 															IDs: []*armnetwork.SubResource{
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
		// 																},
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
		// 																},
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
		// 															}},
		// 															Labels: []*string{
		// 																to.Ptr("label1"),
		// 																to.Ptr("label2")},
		// 															},
		// 															VnetRoutes: &armnetwork.VnetRoute{
		// 																StaticRoutes: []*armnetwork.StaticRoute{
		// 																},
		// 															},
		// 														},
		// 														VPNLinkConnections: []*armnetwork.VPNSiteLinkConnection{
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link1"),
		// 																Name: to.Ptr("Connection-Link1"),
		// 																Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
		// 																Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																Properties: &armnetwork.VPNSiteLinkConnectionProperties{
		// 																	ConnectionBandwidth: to.Ptr[int32](200),
		// 																	EgressBytesTransferred: to.Ptr[int64](0),
		// 																	EgressNatRules: []*armnetwork.SubResource{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
		// 																	}},
		// 																	EnableBgp: to.Ptr(false),
		// 																	EnableRateLimiting: to.Ptr(false),
		// 																	IngressBytesTransferred: to.Ptr[int64](0),
		// 																	IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																	},
		// 																	ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																	RoutingWeight: to.Ptr[int32](0),
		// 																	SharedKey: to.Ptr("key"),
		// 																	UseLocalAzureIPAddress: to.Ptr(false),
		// 																	UsePolicyBasedTrafficSelectors: to.Ptr(false),
		// 																	VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
		// 																	VPNSiteLink: &armnetwork.SubResource{
		// 																		ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
		// 																	},
		// 																},
		// 															},
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link2"),
		// 																Name: to.Ptr("Connection-Link2"),
		// 																Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
		// 																Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																Properties: &armnetwork.VPNSiteLinkConnectionProperties{
		// 																	ConnectionBandwidth: to.Ptr[int32](200),
		// 																	EgressBytesTransferred: to.Ptr[int64](0),
		// 																	EgressNatRules: []*armnetwork.SubResource{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
		// 																	}},
		// 																	EnableBgp: to.Ptr(false),
		// 																	EnableRateLimiting: to.Ptr(false),
		// 																	IngressBytesTransferred: to.Ptr[int64](0),
		// 																	IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																	},
		// 																	ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																	RoutingWeight: to.Ptr[int32](0),
		// 																	SharedKey: to.Ptr("key"),
		// 																	UseLocalAzureIPAddress: to.Ptr(false),
		// 																	UsePolicyBasedTrafficSelectors: to.Ptr(false),
		// 																	VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
		// 																	VPNSiteLink: &armnetwork.SubResource{
		// 																		ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink2"),
		// 																	},
		// 																},
		// 														}},
		// 													},
		// 											}},
		// 											EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 											IsRoutingPreferenceInternet: to.Ptr(false),
		// 											NatRules: []*armnetwork.VPNGatewayNatRule{
		// 												{
		// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
		// 													Name: to.Ptr("nat03"),
		// 													Type: to.Ptr("Microsoft.Network/vpnGateways/natRules"),
		// 													Properties: &armnetwork.VPNGatewayNatRuleProperties{
		// 														Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 														EgressVPNSiteLinkConnections: []*armnetwork.SubResource{
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link1"),
		// 														}},
		// 														ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("192.168.0.0/26"),
		// 														}},
		// 														InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("0.0.0.0/26"),
		// 														}},
		// 														Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
		// 													},
		// 											}},
		// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 											VirtualHub: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
		// 											},
		// 										},
		// 									},
		// 									{
		// 										Name: to.Ptr("gateway2"),
		// 										Type: to.Ptr("Microsoft.Network/vpnGateways"),
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnGateways/gateway2"),
		// 										Location: to.Ptr("West US"),
		// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 										Properties: &armnetwork.VPNGatewayProperties{
		// 											BgpSettings: &armnetwork.BgpSettings{
		// 												Asn: to.Ptr[int64](65514),
		// 												BgpPeeringAddress: to.Ptr("10.0.1.30"),
		// 												BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
		// 													{
		// 														CustomBgpIPAddresses: []*string{
		// 															to.Ptr("169.254.21.5")},
		// 															DefaultBgpIPAddresses: []*string{
		// 																to.Ptr("10.30.0.4")},
		// 																IPConfigurationID: to.Ptr("Instance0"),
		// 																TunnelIPAddresses: []*string{
		// 																	to.Ptr("104.208.48.178")},
		// 																},
		// 																{
		// 																	CustomBgpIPAddresses: []*string{
		// 																		to.Ptr("169.254.21.10")},
		// 																		DefaultBgpIPAddresses: []*string{
		// 																			to.Ptr("10.30.0.5")},
		// 																			IPConfigurationID: to.Ptr("Instance1"),
		// 																			TunnelIPAddresses: []*string{
		// 																				to.Ptr("104.208.48.179")},
		// 																		}},
		// 																		PeerWeight: to.Ptr[int32](0),
		// 																	},
		// 																	Connections: []*armnetwork.VPNConnection{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnGateways/gateway2/vpnConnections/vpnConnection2"),
		// 																			Name: to.Ptr("vpnConnection1"),
		// 																			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																			Properties: &armnetwork.VPNConnectionProperties{
		// 																				ConnectionBandwidth: to.Ptr[int32](100),
		// 																				ConnectionStatus: to.Ptr(armnetwork.VPNConnectionStatusConnected),
		// 																				EgressBytesTransferred: to.Ptr[int64](0),
		// 																				EnableBgp: to.Ptr(false),
		// 																				IngressBytesTransferred: to.Ptr[int64](0),
		// 																				IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																				},
		// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																				RemoteVPNSite: &armnetwork.SubResource{
		// 																					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnSites/vpnSite2"),
		// 																				},
		// 																				RoutingConfiguration: &armnetwork.RoutingConfiguration{
		// 																					AssociatedRouteTable: &armnetwork.SubResource{
		// 																						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable1"),
		// 																					},
		// 																					PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
		// 																						IDs: []*armnetwork.SubResource{
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable1"),
		// 																							},
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable2"),
		// 																							},
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable3"),
		// 																						}},
		// 																						Labels: []*string{
		// 																							to.Ptr("label1"),
		// 																							to.Ptr("label2")},
		// 																						},
		// 																						VnetRoutes: &armnetwork.VnetRoute{
		// 																							StaticRoutes: []*armnetwork.StaticRoute{
		// 																							},
		// 																						},
		// 																					},
		// 																					RoutingWeight: to.Ptr[int32](0),
		// 																					SharedKey: to.Ptr("key"),
		// 																					UseLocalAzureIPAddress: to.Ptr(false),
		// 																				},
		// 																		}},
		// 																		EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 																		IsRoutingPreferenceInternet: to.Ptr(false),
		// 																		NatRules: []*armnetwork.VPNGatewayNatRule{
		// 																		},
		// 																		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																		VirtualHub: &armnetwork.SubResource{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2"),
		// 																		},
		// 																	},
		// 															}},
		// 														}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VpnGatewayList.json
func ExampleVPNGatewaysClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVPNGatewaysClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListVPNGatewaysResult = armnetwork.ListVPNGatewaysResult{
		// 	Value: []*armnetwork.VPNGateway{
		// 		{
		// 			Name: to.Ptr("gateway1"),
		// 			Type: to.Ptr("Microsoft.Network/vpnGateways"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1"),
		// 			Location: to.Ptr("West US"),
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.VPNGatewayProperties{
		// 				BgpSettings: &armnetwork.BgpSettings{
		// 					Asn: to.Ptr[int64](65514),
		// 					BgpPeeringAddress: to.Ptr("10.0.1.30"),
		// 					BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
		// 						{
		// 							CustomBgpIPAddresses: []*string{
		// 								to.Ptr("169.254.21.5")},
		// 								DefaultBgpIPAddresses: []*string{
		// 									to.Ptr("10.30.0.4")},
		// 									IPConfigurationID: to.Ptr("Instance0"),
		// 									TunnelIPAddresses: []*string{
		// 										to.Ptr("104.208.48.178")},
		// 									},
		// 									{
		// 										CustomBgpIPAddresses: []*string{
		// 											to.Ptr("169.254.21.10")},
		// 											DefaultBgpIPAddresses: []*string{
		// 												to.Ptr("10.30.0.5")},
		// 												IPConfigurationID: to.Ptr("Instance1"),
		// 												TunnelIPAddresses: []*string{
		// 													to.Ptr("104.208.48.179")},
		// 											}},
		// 											PeerWeight: to.Ptr[int32](0),
		// 										},
		// 										Connections: []*armnetwork.VPNConnection{
		// 											{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1"),
		// 												Name: to.Ptr("vpnConnection1"),
		// 												Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 												Properties: &armnetwork.VPNConnectionProperties{
		// 													EgressBytesTransferred: to.Ptr[int64](0),
		// 													EnableInternetSecurity: to.Ptr(false),
		// 													IngressBytesTransferred: to.Ptr[int64](0),
		// 													ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 													RemoteVPNSite: &armnetwork.SubResource{
		// 														ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
		// 													},
		// 													RoutingConfiguration: &armnetwork.RoutingConfiguration{
		// 														AssociatedRouteTable: &armnetwork.SubResource{
		// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
		// 														},
		// 														PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
		// 															IDs: []*armnetwork.SubResource{
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
		// 																},
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
		// 																},
		// 																{
		// 																	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
		// 															}},
		// 															Labels: []*string{
		// 																to.Ptr("label1"),
		// 																to.Ptr("label2")},
		// 															},
		// 															VnetRoutes: &armnetwork.VnetRoute{
		// 																StaticRoutes: []*armnetwork.StaticRoute{
		// 																},
		// 															},
		// 														},
		// 														VPNLinkConnections: []*armnetwork.VPNSiteLinkConnection{
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link1"),
		// 																Name: to.Ptr("Connection-Link1"),
		// 																Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
		// 																Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																Properties: &armnetwork.VPNSiteLinkConnectionProperties{
		// 																	ConnectionBandwidth: to.Ptr[int32](200),
		// 																	EgressBytesTransferred: to.Ptr[int64](0),
		// 																	EnableBgp: to.Ptr(false),
		// 																	EnableRateLimiting: to.Ptr(false),
		// 																	IngressBytesTransferred: to.Ptr[int64](0),
		// 																	IngressNatRules: []*armnetwork.SubResource{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
		// 																	}},
		// 																	IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																	},
		// 																	ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																	RoutingWeight: to.Ptr[int32](0),
		// 																	SharedKey: to.Ptr("key"),
		// 																	UseLocalAzureIPAddress: to.Ptr(false),
		// 																	UsePolicyBasedTrafficSelectors: to.Ptr(false),
		// 																	VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
		// 																	VPNSiteLink: &armnetwork.SubResource{
		// 																		ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
		// 																	},
		// 																},
		// 															},
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/VpnSiteLinkConnections/Connection-Link2"),
		// 																Name: to.Ptr("Connection-Link2"),
		// 																Type: to.Ptr("Microsoft.Network/vpnGateways/vpnConnections/VpnSiteLinkConnections"),
		// 																Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																Properties: &armnetwork.VPNSiteLinkConnectionProperties{
		// 																	ConnectionBandwidth: to.Ptr[int32](200),
		// 																	EgressBytesTransferred: to.Ptr[int64](0),
		// 																	EgressNatRules: []*armnetwork.SubResource{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat04"),
		// 																	}},
		// 																	EnableBgp: to.Ptr(false),
		// 																	EnableRateLimiting: to.Ptr(false),
		// 																	IngressBytesTransferred: to.Ptr[int64](0),
		// 																	IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																	},
		// 																	ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																	RoutingWeight: to.Ptr[int32](0),
		// 																	SharedKey: to.Ptr("key"),
		// 																	UseLocalAzureIPAddress: to.Ptr(false),
		// 																	UsePolicyBasedTrafficSelectors: to.Ptr(false),
		// 																	VPNConnectionProtocolType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionProtocolIKEv2),
		// 																	VPNSiteLink: &armnetwork.SubResource{
		// 																		ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink2"),
		// 																	},
		// 																},
		// 														}},
		// 													},
		// 											}},
		// 											EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 											IsRoutingPreferenceInternet: to.Ptr(false),
		// 											NatRules: []*armnetwork.VPNGatewayNatRule{
		// 												{
		// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
		// 													Name: to.Ptr("nat03"),
		// 													Type: to.Ptr("Microsoft.Network/vpnGateways/natRules"),
		// 													Properties: &armnetwork.VPNGatewayNatRuleProperties{
		// 														Type: to.Ptr(armnetwork.VPNNatRuleTypeDynamic),
		// 														ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("192.168.0.0/26"),
		// 														}},
		// 														IngressVPNSiteLinkConnections: []*armnetwork.SubResource{
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link1"),
		// 														}},
		// 														InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("0.0.0.0/26"),
		// 														}},
		// 														Mode: to.Ptr(armnetwork.VPNNatRuleMode("IgressSnat")),
		// 													},
		// 												},
		// 												{
		// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat04"),
		// 													Name: to.Ptr("nat04"),
		// 													Type: to.Ptr("Microsoft.Network/vpnGateways/natRules"),
		// 													Properties: &armnetwork.VPNGatewayNatRuleProperties{
		// 														Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 														EgressVPNSiteLinkConnections: []*armnetwork.SubResource{
		// 															{
		// 																ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/vpnConnection1/vpnLinkConnections/Connection-Link2"),
		// 														}},
		// 														ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("192.168.0.0/26"),
		// 														}},
		// 														InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 															{
		// 																AddressSpace: to.Ptr("0.0.0.0/26"),
		// 														}},
		// 														Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
		// 													},
		// 											}},
		// 											ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 											VirtualHub: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
		// 											},
		// 										},
		// 									},
		// 									{
		// 										Name: to.Ptr("gateway2"),
		// 										Type: to.Ptr("Microsoft.Network/vpnGateways"),
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnGateways/gateway2"),
		// 										Location: to.Ptr("West US"),
		// 										Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 										Properties: &armnetwork.VPNGatewayProperties{
		// 											BgpSettings: &armnetwork.BgpSettings{
		// 												Asn: to.Ptr[int64](65514),
		// 												BgpPeeringAddress: to.Ptr("10.0.1.30"),
		// 												BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
		// 													{
		// 														CustomBgpIPAddresses: []*string{
		// 															to.Ptr("169.254.21.5")},
		// 															DefaultBgpIPAddresses: []*string{
		// 																to.Ptr("10.30.0.4")},
		// 																IPConfigurationID: to.Ptr("Instance0"),
		// 																TunnelIPAddresses: []*string{
		// 																	to.Ptr("104.208.48.178")},
		// 																},
		// 																{
		// 																	CustomBgpIPAddresses: []*string{
		// 																		to.Ptr("169.254.21.10")},
		// 																		DefaultBgpIPAddresses: []*string{
		// 																			to.Ptr("10.30.0.5")},
		// 																			IPConfigurationID: to.Ptr("Instance1"),
		// 																			TunnelIPAddresses: []*string{
		// 																				to.Ptr("104.208.48.179")},
		// 																		}},
		// 																		PeerWeight: to.Ptr[int32](0),
		// 																	},
		// 																	Connections: []*armnetwork.VPNConnection{
		// 																		{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnGateways/gateway2/vpnConnections/vpnConnection2"),
		// 																			Name: to.Ptr("vpnConnection1"),
		// 																			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 																			Properties: &armnetwork.VPNConnectionProperties{
		// 																				ConnectionBandwidth: to.Ptr[int32](100),
		// 																				ConnectionStatus: to.Ptr(armnetwork.VPNConnectionStatusConnected),
		// 																				EgressBytesTransferred: to.Ptr[int64](0),
		// 																				EnableBgp: to.Ptr(false),
		// 																				IngressBytesTransferred: to.Ptr[int64](0),
		// 																				IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 																				},
		// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																				RemoteVPNSite: &armnetwork.SubResource{
		// 																					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/vpnSites/vpnSite2"),
		// 																				},
		// 																				RoutingConfiguration: &armnetwork.RoutingConfiguration{
		// 																					AssociatedRouteTable: &armnetwork.SubResource{
		// 																						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable1"),
		// 																					},
		// 																					PropagatedRouteTables: &armnetwork.PropagatedRouteTable{
		// 																						IDs: []*armnetwork.SubResource{
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable1"),
		// 																							},
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable2"),
		// 																							},
		// 																							{
		// 																								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2/hubRouteTables/hubRouteTable3"),
		// 																						}},
		// 																						Labels: []*string{
		// 																							to.Ptr("label1"),
		// 																							to.Ptr("label2")},
		// 																						},
		// 																						VnetRoutes: &armnetwork.VnetRoute{
		// 																							StaticRoutes: []*armnetwork.StaticRoute{
		// 																							},
		// 																						},
		// 																					},
		// 																					RoutingWeight: to.Ptr[int32](0),
		// 																					SharedKey: to.Ptr("key"),
		// 																					UseLocalAzureIPAddress: to.Ptr(false),
		// 																				},
		// 																		}},
		// 																		EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 																		IsRoutingPreferenceInternet: to.Ptr(false),
		// 																		NatRules: []*armnetwork.VPNGatewayNatRule{
		// 																		},
		// 																		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																		VirtualHub: &armnetwork.SubResource{
		// 																			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualHubs/virtualHub2"),
		// 																		},
		// 																	},
		// 															}},
		// 														}
	}
}
