//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	"net/http"
	"net/url"
	"regexp"
)

// ExternalNetworksServer is a fake server for instances of the armmanagednetworkfabric.ExternalNetworksClient type.
type ExternalNetworksServer struct {
	// BeginCreate is the fake for method ExternalNetworksClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, body armmanagednetworkfabric.ExternalNetwork, options *armmanagednetworkfabric.ExternalNetworksClientBeginCreateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ExternalNetworksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, options *armmanagednetworkfabric.ExternalNetworksClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExternalNetworksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, options *armmanagednetworkfabric.ExternalNetworksClientGetOptions) (resp azfake.Responder[armmanagednetworkfabric.ExternalNetworksClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByL3IsolationDomainPager is the fake for method ExternalNetworksClient.NewListByL3IsolationDomainPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByL3IsolationDomainPager func(resourceGroupName string, l3IsolationDomainName string, options *armmanagednetworkfabric.ExternalNetworksClientListByL3IsolationDomainOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.ExternalNetworksClientListByL3IsolationDomainResponse])

	// BeginUpdate is the fake for method ExternalNetworksClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, body armmanagednetworkfabric.ExternalNetworkPatch, options *armmanagednetworkfabric.ExternalNetworksClientBeginUpdateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAdministrativeState is the fake for method ExternalNetworksClient.BeginUpdateAdministrativeState
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAdministrativeState func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.ExternalNetworksClientBeginUpdateAdministrativeStateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateAdministrativeStateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateStaticRouteBfdAdministrativeState is the fake for method ExternalNetworksClient.BeginUpdateStaticRouteBfdAdministrativeState
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateStaticRouteBfdAdministrativeState func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, externalNetworkName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.ExternalNetworksClientBeginUpdateStaticRouteBfdAdministrativeStateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateStaticRouteBfdAdministrativeStateResponse], errResp azfake.ErrorResponder)
}

// NewExternalNetworksServerTransport creates a new instance of ExternalNetworksServerTransport with the provided implementation.
// The returned ExternalNetworksServerTransport instance is connected to an instance of armmanagednetworkfabric.ExternalNetworksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExternalNetworksServerTransport(srv *ExternalNetworksServer) *ExternalNetworksServerTransport {
	return &ExternalNetworksServerTransport{
		srv:                             srv,
		beginCreate:                     newTracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientCreateResponse]](),
		beginDelete:                     newTracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientDeleteResponse]](),
		newListByL3IsolationDomainPager: newTracker[azfake.PagerResponder[armmanagednetworkfabric.ExternalNetworksClientListByL3IsolationDomainResponse]](),
		beginUpdate:                     newTracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateResponse]](),
		beginUpdateAdministrativeState:  newTracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateAdministrativeStateResponse]](),
		beginUpdateStaticRouteBfdAdministrativeState: newTracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateStaticRouteBfdAdministrativeStateResponse]](),
	}
}

// ExternalNetworksServerTransport connects instances of armmanagednetworkfabric.ExternalNetworksClient to instances of ExternalNetworksServer.
// Don't use this type directly, use NewExternalNetworksServerTransport instead.
type ExternalNetworksServerTransport struct {
	srv                                          *ExternalNetworksServer
	beginCreate                                  *tracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientCreateResponse]]
	beginDelete                                  *tracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientDeleteResponse]]
	newListByL3IsolationDomainPager              *tracker[azfake.PagerResponder[armmanagednetworkfabric.ExternalNetworksClientListByL3IsolationDomainResponse]]
	beginUpdate                                  *tracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateResponse]]
	beginUpdateAdministrativeState               *tracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateAdministrativeStateResponse]]
	beginUpdateStaticRouteBfdAdministrativeState *tracker[azfake.PollerResponder[armmanagednetworkfabric.ExternalNetworksClientUpdateStaticRouteBfdAdministrativeStateResponse]]
}

// Do implements the policy.Transporter interface for ExternalNetworksServerTransport.
func (e *ExternalNetworksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExternalNetworksClient.BeginCreate":
		resp, err = e.dispatchBeginCreate(req)
	case "ExternalNetworksClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "ExternalNetworksClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExternalNetworksClient.NewListByL3IsolationDomainPager":
		resp, err = e.dispatchNewListByL3IsolationDomainPager(req)
	case "ExternalNetworksClient.BeginUpdate":
		resp, err = e.dispatchBeginUpdate(req)
	case "ExternalNetworksClient.BeginUpdateAdministrativeState":
		resp, err = e.dispatchBeginUpdateAdministrativeState(req)
	case "ExternalNetworksClient.BeginUpdateStaticRouteBfdAdministrativeState":
		resp, err = e.dispatchBeginUpdateStaticRouteBfdAdministrativeState(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := e.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.ExternalNetwork](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreate(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		e.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		e.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		e.beginCreate.remove(req)
	}

	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
	if err != nil {
		return nil, err
	}
	externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExternalNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchNewListByL3IsolationDomainPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByL3IsolationDomainPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByL3IsolationDomainPager not implemented")}
	}
	newListByL3IsolationDomainPager := e.newListByL3IsolationDomainPager.get(req)
	if newListByL3IsolationDomainPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByL3IsolationDomainPager(resourceGroupNameParam, l3IsolationDomainNameParam, nil)
		newListByL3IsolationDomainPager = &resp
		e.newListByL3IsolationDomainPager.add(req, newListByL3IsolationDomainPager)
		server.PagerResponderInjectNextLinks(newListByL3IsolationDomainPager, req, func(page *armmanagednetworkfabric.ExternalNetworksClientListByL3IsolationDomainResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByL3IsolationDomainPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByL3IsolationDomainPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByL3IsolationDomainPager) {
		e.newListByL3IsolationDomainPager.remove(req)
	}
	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := e.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.ExternalNetworkPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpdate(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		e.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		e.beginUpdate.remove(req)
	}

	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchBeginUpdateAdministrativeState(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpdateAdministrativeState == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAdministrativeState not implemented")}
	}
	beginUpdateAdministrativeState := e.beginUpdateAdministrativeState.get(req)
	if beginUpdateAdministrativeState == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateAdministrativeState`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpdateAdministrativeState(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAdministrativeState = &respr
		e.beginUpdateAdministrativeState.add(req, beginUpdateAdministrativeState)
	}

	resp, err := server.PollerResponderNext(beginUpdateAdministrativeState, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginUpdateAdministrativeState.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAdministrativeState) {
		e.beginUpdateAdministrativeState.remove(req)
	}

	return resp, nil
}

func (e *ExternalNetworksServerTransport) dispatchBeginUpdateStaticRouteBfdAdministrativeState(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpdateStaticRouteBfdAdministrativeState == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateStaticRouteBfdAdministrativeState not implemented")}
	}
	beginUpdateStaticRouteBfdAdministrativeState := e.beginUpdateStaticRouteBfdAdministrativeState.get(req)
	if beginUpdateStaticRouteBfdAdministrativeState == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/externalNetworks/(?P<externalNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateStaticRouteBfdAdministrativeState`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		externalNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpdateStaticRouteBfdAdministrativeState(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, externalNetworkNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateStaticRouteBfdAdministrativeState = &respr
		e.beginUpdateStaticRouteBfdAdministrativeState.add(req, beginUpdateStaticRouteBfdAdministrativeState)
	}

	resp, err := server.PollerResponderNext(beginUpdateStaticRouteBfdAdministrativeState, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginUpdateStaticRouteBfdAdministrativeState.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateStaticRouteBfdAdministrativeState) {
		e.beginUpdateStaticRouteBfdAdministrativeState.remove(req)
	}

	return resp, nil
}
