/**
 * Copyright 2015 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JogAmp Community ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JogAmp Community OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of JogAmp Community.
 */
package com.jogamp.gluegen;

import java.io.OutputStream;
import java.io.Reader;
import java.util.List;

import com.jogamp.gluegen.jcpp.LexerException;

/**
 * Generic C preprocessor interface for GlueGen
 */
public interface GenericCPP {

    public void addDefine(String name, String value) throws LexerException;

    public String findFile(String filename);

    public OutputStream out();
    public void setOut(OutputStream out);

    public void run(Reader reader, String filename) throws GlueGenException;

    /**
     * Returns a list of {@link ConstantDefinition}, i.e.
     * <i>non-function-like</i> and <i>non-empty</i> macros w/ <i>constant-value</i>,
     * as derived during parsing.
     * <p>
     * May return an empty list, in case this preprocessor does not
     * store {@link ConstantDefinition}s.
     * </p>
     * @throws GlueGenException
     */
    public List<ConstantDefinition> getConstantDefinitions() throws GlueGenException;


}